-------------------------------------------------------
-- Created by Ben Cope of Imperial College (March 2006)
-- Top Level for Filter block
-------------------------------------------------------

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;

library UNISIM;
use UNISIM.VComponents.all;

LIBRARY work;
USE work.Constants.ALL;
USE work.ALL;

ENTITY Fir_filter IS
    PORT (clock : IN STD_LOGIC;
			 reset : IN STD_LOGIC;
			 RGB_in : IN CHANNEL_TYPE;
			 RGB_out : OUT CHANNEL_TYPE);
END Fir_filter;

ARCHITECTURE inside OF Fir_filter IS

-- Pipelining 

SIGNAL RGB_in_buffer, RGB_out_buffer : CHANNEL_TYPE;
SIGNAL valid_vector : STD_LOGIC_VECTOR(0 TO n-2);

-- Storage of Pixels
SIGNAL FIFO_RGB_OUT : Channel_1xn;

-- Pixels to Compute
SIGNAL RGB_compute : Channel_nxn;

BEGIN

--------------------------------------------------
-- Pipelining
--------------------------------------------------

Pipe: PROCESS

BEGIN
 WAIT UNTIL Rising_Edge(clock);
  RGB_in_buffer <= RGB_in;
  FOR i IN 0 TO n-2 LOOP
   valid_vector(i) <= RGB_in.valid;
  END LOOP;

  RGB_out <= RGB_out_buffer;
END PROCESS Pipe;

--------------------------------------------------
-- Perform Multiplication / Adder Tree
--------------------------------------------------

 E1: ENTITY Evaluate
 PORT MAP(
  clock => clock,
  reset => reset,
  RGB_compute => RGB_compute,
  compute => RGB_in_buffer.valid,
  output_valid => RGB_out_buffer.valid,
  output => RGB_out_buffer.RGB);

--------------------------------------------------
-- Handle Multiply Array (RGB_compute)
--------------------------------------------------

 setup_M_array: PROCESS

 BEGIN
  WAIT UNTIL Rising_Edge(clock);

   IF (reset = '1') THEN

    FOR i IN 0 TO n-1 LOOP
     FOR j IN 0 TO n-1 LOOP
      FOR k IN 0 TO 2 LOOP
       --RGB_compute(i)(j).RGB(k) <= (OTHERS => '0');
       RGB_compute(i)(j).valid <= '0';
      END LOOP;
     END LOOP;
    END LOOP;

   ELSE

--    IF RGB_in_buffer.valid = '1' THEN
     RGB_compute(0)(0) <= RGB_in_buffer;
     FOR i IN 1 TO n-1 LOOP
      RGB_compute(i)(0) <= FIFO_RGB_OUT(i-1);
     END LOOP;
     FOR i IN 0 TO n-1 LOOP
      FOR j IN 0 TO n-2 LOOP
       FOR k IN 0 TO 2 LOOP
        RGB_compute(i)(j+1).RGB(k) <= RGB_compute(i)(j).RGB(k);
       END LOOP;
       RGB_compute(i)(j+1).valid <= RGB_compute(i)(j).valid;
      END LOOP;
     END LOOP;
--    END IF;
   END IF;   
  END PROCESS setup_M_array;

--------------------------------------------------
-- Handle FIFO's
--------------------------------------------------

 G1: FOR i IN 0 TO n-2 GENERATE
  F: ENTITY FIFO_block PORT MAP(
   clock => clock,
   reset => reset,
   enable => '1', --valid_vector(i),
   RGB_in => RGB_compute(i)(n-1),
   RGB_out => FIFO_RGB_OUT(i));
 END GENERATE;

END inside;
